#!/bin/sh
ORACLE_SID=ORCL
export ORACLE_SID

/usr/oracle/bin/svrmgrl << EOF
spool ./01crdb.log
connect internal
startup nomount pfile = /usr/oracle/orcl/pfile/initORCL.ora

CREATE DATABASE "ORCL"
   CONTROLFILE REUSE
   MAXDATAFILES 254
   MAXINSTANCES 8
   MAXLOGFILES 16
   MAXLOGMEMBERS 2
   CHARACTER SET JA16SJIS
   NATIONAL CHARACTER SET JA16SJIS
   NOARCHIVELOG
   DATAFILE '/usr/oracle/orcl/data/data.dbf' SIZE 150M reuse
   LOGFILE
   GROUP 1 ('/usr/oracle/orcl/data/log1.dbf',
            '/usr/oracle/orcl/data/log2.dbf') SIZE 10M,
   GROUP 2 ('/usr/oracle/orcl/data/log3.dbf',
            '/usr/oracle/orcl/data/log4.dbf') SIZE 10M
;

disconnect
spool off
exit

EOF

